# Replication Code for International Trade and Risk in Bilateral Exchange Rates.

This generates the empirical results for our paper "International Trade and Risk in Bilateral Exchange Rates" (Ramin Hassan, Erik Loualiche, Alexandre R. Pecora, and Colin Ward) for publication at the *Journal of Financial Economics.*

See the model folder for replication of the simulation and calibration of the model.

## How to run the code

Replace line 6 and 7 of the `Makefile` file with the path of your R and julia binaries. 

The diagram `data-diagram.svg` shows the dependency graph for the empirical side of the project.


- Installing prerequisites: run `make setup-environment` which will install `R` and `stata` necessary packages.
  - If you do not run the setup (because you do not want this code to mess with your installs), make sure  you have all the `R` and `stata` packages installed (listed in `setup-environment` files).
  - Be careful, the code requires you to install an older version of the `did` package (see `setup-environment.R` for more details)

**IMPORTANT:** Note that this repository does not include the data on exchange rates (collected from bloomberg). 
   - The folder architecture explains how to download the data for the code to run.
   - There are two synthetic datasets which look like the original dataset `FX_daily.csv` and `FX_daily_long.csv`.
      - These two tables aggregate (wide and long format) the raw bloomberg data. The data is still synthetic (noisy and biased) and **will not reproduce the numbers in the tables** as is.
      - You need to download the actual daily data for the tables to match.

## Data sources

1. **EIA agreements**
Available from the [Database on Economic Integration Agreements ](https://kellogg.nd.edu/nsf-kellogg-institute-data-base-economic-integration-agreements) (April 2017)
The newest dataset was not available at the time we wrote the paper

2. **EIA agreements after 2012:** manually collected from various sources
  - a.  https://www.consilium.europa.eu/en/policies/trade-policy/trade-agreements/ 
  - b.  https://ec.europa.eu/trade/policy/countries-and-regions/negotiations-and-agreements/ 
  - c.  https://www.efta.int/Free-Trade/Free-Trade-Agreements-510711 
  - d.  http://www.sice.oas.org/agreements_e.asp                    
  - e.  https://aric.adb.org/database/fta         

3. **Daily Exchange Rates:** collected from DataPlanet (source: FED) and Bloomberg closed prices (PX_LAST)
   - Currencies collected from DataPlanet were: `("AUD","BRL","CAD","CHF","CNY","DKK","EUR","GBP","HKD","INR","JPY","KRW",
"MXN","MYR","NOK","NZD","SEK","SGD","THB","TWD","ZAR", "LKR" "ESP","PTE", "ITL","IEP","GRD","DEM","FRF","BEF","ATS")`
   - Example: link to USDBRL FX rate currency: https://doi.org/10.6068/DP17281A407DF43
   - Currencies collected from Bloomberg: `("SAR","TRY","RUB","QAR","PHP","PLN","PEN","HUF","CZK","EGP","COP","CLP",
"AED","ILS","IDR","FIM","NLG")`

4. **Country ISO codes:**
   - https://datahub.io/core/country-codes#resource-country-codes_zip

5. **Currency Pegs:**
   - We use data from Harms and Knaze (2021), available at [this link](https://www.international.economics.uni-mainz.de/data-on-bilateral-exchange-rate-regimes/?folder=De-facto%20data)
   - Based on Ilzetzki, Reinhart and Rogoff (2017) 

6. **IMF trade data:**
   - Collected for each combination of exporter and importer country from the [IMF here](https://data.imf.org/?sk=9D6028D4-F14A-464C-A2F2-59B2CD424B85)

7. **Gravity and GDP data:** from the Centre d'Etudes Prospectives et d'Informations Internationales (CEPII) available [here](http://www.cepii.fr/CEPII/en/bdd_modele/bdd_modele_item.asp?id=8)

